<?php

class EWRporta_DataWriter_Cache extends XenForo_DataWriter
{
	protected $_existingDataErrorPhrase = 'requested_page_not_found';

	protected function _getFields()
	{
		return array(
			'EWRporta_cache' => array(
				'module_name'		=> array('type' => self::TYPE_STRING, 'required' => true),
				'module_date'		=> array('type' => self::TYPE_UINT, 'required' => true),
				'module_settings'	=> array('type' => self::TYPE_STRING, 'required' => true),
			)
		);
	}

	protected function _getExistingData($data)
	{
		if (!$modName = $this->_getExistingPrimaryKey($data, 'module_name'))
		{
			return false;
		}

		return array('EWRporta_cache' => $this->getModelFromCache('EWRporta_Model_Cache')->getCacheByName($modName));
	}

	protected function _getUpdateCondition($tableName)
	{
		return 'module_name = ' . $this->_db->quote($this->getExisting('module_name'));
	}

	protected function _preSave()
	{
		$this->set('module_date', XenForo_Application::$time);
	}
}